-- phpMyAdmin SQL Dump
-- version 4.4.10
-- http://www.phpmyadmin.net
--
-- Host: localhost:3306
-- Generation Time: Jun 10, 2016 at 07:49 AM
-- Server version: 5.5.42
-- PHP Version: 5.6.10

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";
SET FOREIGN_KEY_CHECKS = 0;


/*!40101 SET @OLD_CHARACTER_SET_CLIENT = @@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS = @@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION = @@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `laraclassified`
--

-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>advertising`
--

DROP TABLE IF EXISTS `<<prefix>>advertising`;
CREATE TABLE `<<prefix>>advertising`
(
	`id` int(10) UNSIGNED NOT NULL,
	`slug` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
	`provider_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`tracking_code_large` text COLLATE utf8_unicode_ci,
	`tracking_code_medium` text COLLATE utf8_unicode_ci,
	`tracking_code_small` text COLLATE utf8_unicode_ci,
	`active` tinyint(1) UNSIGNED DEFAULT '1'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>advertising`
--
ALTER TABLE `<<prefix>>advertising`
	ADD PRIMARY KEY (`id`),
	ADD UNIQUE KEY `slug` (`slug`),
	ADD KEY `active` (`active`);

--
-- AUTO_INCREMENT for table `<<prefix>>advertising`
--
ALTER TABLE `<<prefix>>advertising`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>blacklist`
--

DROP TABLE IF EXISTS `<<prefix>>blacklist`;
CREATE TABLE `<<prefix>>blacklist`
(
	`id` int(10) UNSIGNED NOT NULL,
	`type` enum ('domain','email','ip','word') COLLATE utf8_unicode_ci DEFAULT NULL,
	`entry` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT ''
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>blacklist`
--
ALTER TABLE `<<prefix>>blacklist`
	ADD PRIMARY KEY (`id`),
	ADD KEY `type` (`type`, `entry`);

--
-- AUTO_INCREMENT for table `<<prefix>>blacklist`
--
ALTER TABLE `<<prefix>>blacklist`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>cache`
--

DROP TABLE IF EXISTS `<<prefix>>cache`;
CREATE TABLE `<<prefix>>cache`
(
	`key` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
	`value` mediumtext COLLATE utf8_unicode_ci,
	`expiration` int(11) DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>cache`
--
ALTER TABLE `<<prefix>>cache`
	ADD UNIQUE KEY `key` (`key`);



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>categories`
--

DROP TABLE IF EXISTS `<<prefix>>categories`;
CREATE TABLE `<<prefix>>categories`
(
	`id` int(10) UNSIGNED NOT NULL,
	`translation_lang` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
	`translation_of` int(10) UNSIGNED DEFAULT NULL,
	`parent_id` int(10) UNSIGNED DEFAULT '0',
	`name` varchar(150) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
	`slug` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
	`description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`picture` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`icon_class` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`lft` int(10) UNSIGNED DEFAULT NULL,
	`rgt` int(10) UNSIGNED DEFAULT NULL,
	`depth` int(10) UNSIGNED DEFAULT NULL,
	`type` enum ('classified','job-offer','job-search','not-salable') COLLATE utf8_unicode_ci DEFAULT 'classified' COMMENT 'Only select this for parent categories',
	`active` tinyint(1) DEFAULT '1'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>categories`
--
ALTER TABLE `<<prefix>>categories`
	ADD PRIMARY KEY (`id`),
	ADD KEY `translation_lang` (`translation_lang`),
	ADD KEY `translation_of` (`translation_of`),
	ADD KEY `parent_id` (`parent_id`),
	ADD KEY `slug` (`slug`);

--
-- AUTO_INCREMENT for table `<<prefix>>categories`
--
ALTER TABLE `<<prefix>>categories`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>category_field`
--

DROP TABLE IF EXISTS `<<prefix>>category_field`;
CREATE TABLE `<<prefix>>category_field`
(
	`id` int(10) UNSIGNED NOT NULL,
	`category_id` int(10) UNSIGNED DEFAULT NULL,
	`field_id` int(10) UNSIGNED DEFAULT NULL,
	`disabled_in_subcategories` tinyint(1) UNSIGNED DEFAULT '0',
	`parent_id` int(10) UNSIGNED DEFAULT NULL,
	`lft` int(10) UNSIGNED DEFAULT NULL,
	`rgt` int(10) UNSIGNED DEFAULT NULL,
	`depth` int(10) UNSIGNED DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>category_field`
--
ALTER TABLE `<<prefix>>category_field`
	ADD PRIMARY KEY (`id`),
	ADD UNIQUE KEY `category_id` (`category_id`, `field_id`);

--
-- AUTO_INCREMENT for table `<<prefix>>category_field`
--
ALTER TABLE `<<prefix>>category_field`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>cities`
--

DROP TABLE IF EXISTS `<<prefix>>cities`;
CREATE TABLE `<<prefix>>cities`
(
	`id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
	`country_code` varchar(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'ISO-3166 2-letter country code, 2 characters',
	`name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'name of geographical point (utf8) varchar(200)',
	`asciiname` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'name of geographical point in plain ascii characters, varchar(200)',
	`latitude` float DEFAULT NULL COMMENT 'latitude in decimal degrees (wgs84)',
	`longitude` float DEFAULT NULL COMMENT 'longitude in decimal degrees (wgs84)',
	`feature_class` char(1) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'see http://www.geonames.org/export/codes.html, char(1)',
	`feature_code` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'see http://www.geonames.org/export/codes.html, varchar(10)',
	`subadmin1_code` varchar(80) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'fipscode (subject to change to iso code), see exceptions below, see file admin1Codes.txt for display names of this code; varchar(20)',
	`subadmin2_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'code for the second administrative division, a county in the US, see file admin2Codes.txt; varchar(80)',
	`population` bigint(20) DEFAULT NULL COMMENT 'bigint (4 byte int)',
	`time_zone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'the timezone id (see file timeZone.txt)',
	`active` tinyint(1) DEFAULT '1',
	`created_at` timestamp NULL DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = COMPACT;

--
-- Indexes for table `<<prefix>>cities`
--
ALTER TABLE `<<prefix>>cities`
	ADD PRIMARY KEY (`id`),
	ADD KEY `country_code` (`country_code`),
	ADD KEY `name` (`name`),
	ADD KEY `subadmin1_code` (`subadmin1_code`),
	ADD KEY `subadmin2_code` (`subadmin2_code`),
	ADD KEY `active` (`active`);



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>continents`
--

DROP TABLE IF EXISTS `<<prefix>>continents`;
CREATE TABLE `<<prefix>>continents`
(
	`id` int(10) UNSIGNED NOT NULL,
	`code` varchar(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
	`name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
	`active` tinyint(1) DEFAULT '1'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>continents`
--
ALTER TABLE `<<prefix>>continents`
	ADD PRIMARY KEY (`id`),
	ADD UNIQUE KEY `code` (`code`),
	ADD KEY `active` (`active`);

--
-- AUTO_INCREMENT for table `<<prefix>>continents`
--
ALTER TABLE `<<prefix>>continents`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>countries`
--

DROP TABLE IF EXISTS `<<prefix>>countries`;
CREATE TABLE `<<prefix>>countries`
(
	`id` int(10) UNSIGNED NOT NULL,
	`code` char(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
	`iso3` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
	`iso_numeric` int(10) UNSIGNED DEFAULT NULL,
	`fips` char(2) COLLATE utf8_unicode_ci DEFAULT NULL,
	`name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`asciiname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`capital` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`area` int(10) UNSIGNED DEFAULT NULL,
	`population` int(10) UNSIGNED DEFAULT NULL,
	`continent_code` char(4) COLLATE utf8_unicode_ci DEFAULT NULL,
	`tld` char(4) COLLATE utf8_unicode_ci DEFAULT NULL,
	`currency_code` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
	`phone` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
	`postal_code_format` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
	`postal_code_regex` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
	`languages` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
	`neighbours` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
	`equivalent_fips_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`background_image` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`admin_type` enum ('0','1','2') COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
	`admin_field_active` tinyint(1) UNSIGNED DEFAULT '0',
	`active` tinyint(1) DEFAULT '1',
	`created_at` timestamp NULL DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci
  ROW_FORMAT = COMPACT;

--
-- Indexes for table `<<prefix>>countries`
--
ALTER TABLE `<<prefix>>countries`
	ADD PRIMARY KEY (`id`),
	ADD UNIQUE KEY `code` (`code`),
	ADD KEY `active` (`active`);

--
-- AUTO_INCREMENT for table `<<prefix>>countries`
--
ALTER TABLE `<<prefix>>countries`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>currencies`
--

DROP TABLE IF EXISTS `<<prefix>>currencies`;
CREATE TABLE `<<prefix>>currencies`
(
	`id` int(10) UNSIGNED NOT NULL,
	`code` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
	`name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
	`html_entity` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'From Github : An array of currency symbols as HTML entities',
	`font_arial` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
	`font_code2000` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
	`unicode_decimal` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
	`unicode_hex` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
	`in_left` tinyint(1) UNSIGNED DEFAULT '0',
	`decimal_places` int(10) UNSIGNED DEFAULT '2' COMMENT 'Currency Decimal Places - ISO 4217',
	`decimal_separator` varchar(10) COLLATE utf8_unicode_ci DEFAULT '.',
	`thousand_separator` varchar(10) COLLATE utf8_unicode_ci DEFAULT ',',
	`created_at` timestamp NULL DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>currencies`
--
ALTER TABLE `<<prefix>>currencies`
	ADD PRIMARY KEY (`id`),
	ADD UNIQUE KEY `code` (`code`);

--
-- AUTO_INCREMENT for table `<<prefix>>currencies`
--
ALTER TABLE `<<prefix>>currencies`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>fields`
--

DROP TABLE IF EXISTS `<<prefix>>fields`;
CREATE TABLE `<<prefix>>fields`
(
	`id` int(10) UNSIGNED NOT NULL,
	`belongs_to` enum ('posts','users') COLLATE utf8_unicode_ci NOT NULL,
	`translation_lang` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
	`translation_of` int(10) UNSIGNED DEFAULT NULL,
	`name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`type` enum ('text','textarea','checkbox','checkbox_multiple','select','radio','file') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'text',
	`max` int(10) UNSIGNED DEFAULT '255',
	`default` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`required` tinyint(1) UNSIGNED DEFAULT NULL,
	`help` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`active` tinyint(1) UNSIGNED DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>fields`
--
ALTER TABLE `<<prefix>>fields`
	ADD PRIMARY KEY (`id`),
	ADD KEY `translation_lang` (`translation_lang`),
	ADD KEY `translation_of` (`translation_of`),
	ADD KEY `belongs_to` (`belongs_to`),
	ADD KEY `active` (`active`);

--
-- AUTO_INCREMENT for table `<<prefix>>fields`
--
ALTER TABLE `<<prefix>>fields`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>fields_options`
--

DROP TABLE IF EXISTS `<<prefix>>fields_options`;
CREATE TABLE `<<prefix>>fields_options`
(
	`id` bigint(20) UNSIGNED NOT NULL,
	`field_id` int(10) UNSIGNED DEFAULT NULL,
	`translation_lang` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
	`translation_of` bigint(20) UNSIGNED DEFAULT NULL,
	`value` text COLLATE utf8_unicode_ci,
	`parent_id` int(10) UNSIGNED DEFAULT NULL,
	`lft` int(10) UNSIGNED DEFAULT NULL,
	`rgt` int(10) UNSIGNED DEFAULT NULL,
	`depth` int(10) UNSIGNED DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>fields_options`
--
ALTER TABLE `<<prefix>>fields_options`
	ADD PRIMARY KEY (`id`),
	ADD KEY `field_id` (`field_id`),
	ADD KEY `translation_lang` (`translation_lang`),
	ADD KEY `translation_of` (`translation_of`);

--
-- AUTO_INCREMENT for table `<<prefix>>fields_options`
--
ALTER TABLE `<<prefix>>fields_options`
	MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>gender`
--

DROP TABLE IF EXISTS `<<prefix>>gender`;
CREATE TABLE `<<prefix>>gender`
(
	`id` int(10) unsigned NOT NULL,
	`translation_lang` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
	`translation_of` int(10) unsigned DEFAULT NULL,
	`name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>gender`
--
ALTER TABLE `<<prefix>>gender`
	ADD PRIMARY KEY (`id`),
	ADD KEY `translation_lang` (`translation_lang`),
	ADD KEY `translation_of` (`translation_of`);

--
-- AUTO_INCREMENT for table `<<prefix>>gender`
--
ALTER TABLE `<<prefix>>gender`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>home_sections`
--

DROP TABLE IF EXISTS `<<prefix>>home_sections`;
CREATE TABLE `<<prefix>>home_sections`
(
	`id` int(10) UNSIGNED NOT NULL,
	`method` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
	`name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
	`value` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
	`view` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
	`field` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
	`parent_id` int(10) UNSIGNED DEFAULT NULL,
	`lft` int(10) UNSIGNED DEFAULT NULL,
	`rgt` int(10) UNSIGNED DEFAULT NULL,
	`depth` int(10) UNSIGNED DEFAULT NULL,
	`active` tinyint(1) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;

--
-- Indexes for table `<<prefix>>home_sections`
--
ALTER TABLE `<<prefix>>home_sections`
	ADD PRIMARY KEY (`id`),
	ADD KEY `active` (`active`);

--
-- AUTO_INCREMENT for table `<<prefix>>home_sections`
--
ALTER TABLE `<<prefix>>home_sections`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>languages`
--

DROP TABLE IF EXISTS `<<prefix>>languages`;
CREATE TABLE `<<prefix>>languages`
(
	`id` int(10) UNSIGNED NOT NULL,
	`abbr` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
	`locale` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
	`name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
	`native` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
	`flag` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`app_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`script` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
	`direction` enum ('ltr','rtl') COLLATE utf8_unicode_ci NOT NULL DEFAULT 'ltr',
	`russian_pluralization` tinyint(1) UNSIGNED DEFAULT '0',
	`active` tinyint(1) NOT NULL DEFAULT '1',
	`default` tinyint(1) NOT NULL DEFAULT '0',
	`parent_id` int(10) UNSIGNED DEFAULT NULL,
	`lft` int(10) UNSIGNED DEFAULT NULL,
	`rgt` int(10) UNSIGNED DEFAULT NULL,
	`depth` int(10) UNSIGNED DEFAULT NULL,
	`created_at` timestamp NULL DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL,
	`deleted_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>languages`
--
ALTER TABLE `<<prefix>>languages`
	ADD PRIMARY KEY (`id`),
	ADD UNIQUE KEY `abbr` (`abbr`),
	ADD KEY `active` (`active`),
	ADD KEY `default` (`default`);

--
-- AUTO_INCREMENT for table `<<prefix>>languages`
--
ALTER TABLE `<<prefix>>languages`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>messages`
--

DROP TABLE IF EXISTS `<<prefix>>messages`;
CREATE TABLE `<<prefix>>messages`
(
	`id` bigint(20) UNSIGNED NOT NULL,
	`post_id` bigint(20) UNSIGNED DEFAULT '0',
	`parent_id` bigint(20) UNSIGNED DEFAULT '0',
	`from_user_id` bigint(20) UNSIGNED DEFAULT '0',
	`from_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
	`from_email` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
	`from_phone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`to_user_id` bigint(20) UNSIGNED DEFAULT '0',
	`to_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
	`to_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`to_phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
	`subject` text COLLATE utf8_unicode_ci,
	`message` text COLLATE utf8_unicode_ci,
	`filename` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
	`is_read` tinyint(1) UNSIGNED DEFAULT '0',
	`deleted_by` int(10) UNSIGNED DEFAULT NULL,
	`created_at` timestamp NULL DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL,
	`deleted_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>messages`
--
ALTER TABLE `<<prefix>>messages`
	ADD PRIMARY KEY (`id`),
	ADD KEY `post_id` (`post_id`),
	ADD KEY `parent_id` (`parent_id`),
	ADD KEY `from_user_id` (`from_user_id`),
	ADD KEY `to_user_id` (`to_user_id`),
	ADD KEY `deleted_by` (`deleted_by`);

--
-- AUTO_INCREMENT for table `<<prefix>>messages`
--
ALTER TABLE `<<prefix>>messages`
	MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>meta_tags`
--

DROP TABLE IF EXISTS `<<prefix>>meta_tags`;
CREATE TABLE `<<prefix>>meta_tags`
(
	`id` int(10) UNSIGNED NOT NULL,
	`translation_lang` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
	`translation_of` int(10) UNSIGNED NOT NULL,
	`page` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
	`title` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '',
	`description` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '',
	`keywords` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '',
	`active` tinyint(1) UNSIGNED NOT NULL DEFAULT '1'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8;

--
-- Indexes for table `<<prefix>>meta_tags`
--
ALTER TABLE `<<prefix>>meta_tags`
	ADD PRIMARY KEY (`id`),
	ADD KEY `translation_lang` (`translation_lang`),
	ADD KEY `translation_of` (`translation_of`),
	ADD KEY `active` (`active`);

--
-- AUTO_INCREMENT for table `<<prefix>>meta_tags`
--
ALTER TABLE `<<prefix>>meta_tags`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>migrations`
--

DROP TABLE IF EXISTS `<<prefix>>migrations`;
CREATE TABLE `<<prefix>>migrations`
(
	`migration` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
	`batch` int(11) NOT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>packages`
--

DROP TABLE IF EXISTS `<<prefix>>packages`;
CREATE TABLE `<<prefix>>packages`
(
	`id` int(10) UNSIGNED NOT NULL,
	`translation_lang` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
	`translation_of` int(10) UNSIGNED DEFAULT NULL,
	`name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'In country language',
	`short_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'In country language',
	`ribbon` enum ('red','orange','green') COLLATE utf8_unicode_ci DEFAULT NULL,
	`has_badge` tinyint(1) UNSIGNED DEFAULT '0',
	`price` decimal(10, 2) UNSIGNED DEFAULT NULL,
	`currency_code` varchar(3) COLLATE utf8_unicode_ci DEFAULT NULL,
	`duration` int(10) UNSIGNED DEFAULT '30' COMMENT 'In days',
	`description` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'In country language',
	`parent_id` int(10) UNSIGNED DEFAULT NULL,
	`lft` int(10) UNSIGNED DEFAULT NULL,
	`rgt` int(10) UNSIGNED DEFAULT NULL,
	`depth` int(10) UNSIGNED DEFAULT NULL,
	`active` tinyint(1) UNSIGNED DEFAULT '0'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>packages`
--
ALTER TABLE `<<prefix>>packages`
	ADD PRIMARY KEY (`id`),
	ADD KEY `active` (`active`);

--
-- AUTO_INCREMENT for table `<<prefix>>packages`
--
ALTER TABLE `<<prefix>>packages`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>pages`
--

DROP TABLE IF EXISTS `<<prefix>>pages`;
CREATE TABLE `<<prefix>>pages`
(
	`id` int(10) UNSIGNED NOT NULL,
	`translation_lang` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
	`translation_of` int(10) UNSIGNED DEFAULT NULL,
	`parent_id` int(10) UNSIGNED DEFAULT NULL,
	`type` enum ('standard','terms','privacy','tips') COLLATE utf8_unicode_ci NOT NULL,
	`name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`slug` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`title` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
	`picture` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`content` text COLLATE utf8_unicode_ci,
	`external_link` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`lft` int(10) UNSIGNED DEFAULT NULL,
	`rgt` int(10) UNSIGNED DEFAULT NULL,
	`depth` int(10) UNSIGNED DEFAULT NULL,
	`name_color` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
	`title_color` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
	`target_blank` tinyint(1) UNSIGNED DEFAULT '0',
	`excluded_from_footer` tinyint(1) UNSIGNED DEFAULT '0',
	`active` tinyint(1) UNSIGNED DEFAULT '1',
	`created_at` timestamp NULL DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>pages`
--
ALTER TABLE `<<prefix>>pages`
	ADD PRIMARY KEY (`id`),
	ADD KEY `translation_lang` (`translation_lang`),
	ADD KEY `translation_of` (`translation_of`),
	ADD KEY `parent_id` (`parent_id`),
	ADD KEY `active` (`active`);

--
-- AUTO_INCREMENT for table `<<prefix>>pages`
--
ALTER TABLE `<<prefix>>pages`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>password_resets`
--

DROP TABLE IF EXISTS `<<prefix>>password_resets`;
CREATE TABLE `<<prefix>>password_resets`
(
	`email` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
	`phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`created_at` datetime DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>payments`
--

DROP TABLE IF EXISTS `<<prefix>>payments`;
CREATE TABLE `<<prefix>>payments`
(
	`id` int(10) UNSIGNED NOT NULL,
	`post_id` bigint(20) UNSIGNED DEFAULT NULL,
	`package_id` int(10) UNSIGNED DEFAULT NULL,
	`payment_method_id` int(10) UNSIGNED DEFAULT '0',
	`transaction_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'Transaction''s ID at the Provider',
	`active` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
	`created_at` timestamp NULL DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>payments`
--
ALTER TABLE `<<prefix>>payments`
	ADD PRIMARY KEY (`id`),
	ADD KEY `payment_method_id` (`payment_method_id`),
	ADD KEY `package_id` (`package_id`) USING BTREE,
	ADD KEY `post_id` (`post_id`),
	ADD KEY `active` (`active`),
	ADD KEY `transaction_id` (`transaction_id`);

--
-- AUTO_INCREMENT for table `<<prefix>>payments`
--
ALTER TABLE `<<prefix>>payments`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>payment_methods`
--

DROP TABLE IF EXISTS `<<prefix>>payment_methods`;
CREATE TABLE `<<prefix>>payment_methods`
(
	`id` int(10) UNSIGNED NOT NULL,
	`name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`display_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`description` text COLLATE utf8_unicode_ci,
	`has_ccbox` tinyint(1) UNSIGNED DEFAULT '0',
	`is_compatible_api` tinyint(1) DEFAULT '0',
	`countries` text COLLATE utf8_unicode_ci COMMENT 'Countries codes separated by comma.',
	`lft` int(10) UNSIGNED DEFAULT NULL,
	`rgt` int(10) UNSIGNED DEFAULT NULL,
	`depth` int(10) UNSIGNED DEFAULT NULL,
	`parent_id` int(10) UNSIGNED DEFAULT '0',
	`active` tinyint(1) DEFAULT '0'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>payment_methods`
--
ALTER TABLE `<<prefix>>payment_methods`
	ADD PRIMARY KEY (`id`),
	ADD KEY `has_ccbox` (`has_ccbox`),
	ADD KEY `active` (`active`);

--
-- AUTO_INCREMENT for table `<<prefix>>payment_methods`
--
ALTER TABLE `<<prefix>>payment_methods`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>pictures`
--

DROP TABLE IF EXISTS `<<prefix>>pictures`;
CREATE TABLE `<<prefix>>pictures`
(
	`id` bigint(20) UNSIGNED NOT NULL,
	`post_id` bigint(20) UNSIGNED DEFAULT NULL,
	`filename` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`position` int(10) UNSIGNED NOT NULL DEFAULT '0',
	`active` tinyint(1) UNSIGNED DEFAULT '1' COMMENT 'Set at 0 on updating the ad',
	`created_at` timestamp NULL DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>pictures`
--
ALTER TABLE `<<prefix>>pictures`
	ADD PRIMARY KEY (`id`),
	ADD KEY `post_id` (`post_id`),
	ADD KEY `active` (`active`);

--
-- AUTO_INCREMENT for table `<<prefix>>pictures`
--
ALTER TABLE `<<prefix>>pictures`
	MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>posts`
--

DROP TABLE IF EXISTS `<<prefix>>posts`;
CREATE TABLE `<<prefix>>posts`
(
	`id` bigint(20) UNSIGNED NOT NULL,
	`country_code` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL,
	`user_id` bigint(20) UNSIGNED DEFAULT NULL,
	`category_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
	`post_type_id` int(10) UNSIGNED DEFAULT NULL,
	`title` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
	`description` text COLLATE utf8_unicode_ci NOT NULL,
	`tags` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`price` decimal(17, 2) UNSIGNED DEFAULT NULL,
	`negotiable` tinyint(1) DEFAULT '0',
	`contact_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
	`email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
	`phone_hidden` tinyint(1) DEFAULT '0',
	`address` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`city_id` bigint(20) UNSIGNED NOT NULL DEFAULT '0',
	`lon` float DEFAULT NULL COMMENT 'longitude in decimal degrees (wgs84)',
	`lat` float DEFAULT NULL COMMENT 'latitude in decimal degrees (wgs84)',
	`ip_addr` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
	`visits` int(10) UNSIGNED DEFAULT '0',
	`email_token` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
	`phone_token` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
	`tmp_token` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
	`verified_email` tinyint(1) DEFAULT '0',
	`verified_phone` tinyint(1) UNSIGNED DEFAULT '1',
	`reviewed` tinyint(1) UNSIGNED DEFAULT '0',
	`featured` tinyint(1) UNSIGNED DEFAULT '0',
	`archived` tinyint(1) UNSIGNED DEFAULT '0',
	`archived_at` timestamp NULL DEFAULT NULL,
	`archived_manually` tinyint(1) UNSIGNED DEFAULT '0',
	`deletion_mail_sent_at` timestamp NULL DEFAULT NULL,
	`fb_profile` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`partner` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
	`created_at` timestamp NULL DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL,
	`deleted_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>posts`
--
ALTER TABLE `<<prefix>>posts`
	ADD PRIMARY KEY (`id`),
	ADD KEY `lat` (`lon`, `lat`),
	ADD KEY `country_code` (`country_code`),
	ADD KEY `user_id` (`user_id`),
	ADD KEY `category_id` (`category_id`),
	ADD KEY `title` (`title`),
	ADD KEY `address` (`address`),
	ADD KEY `city_id` (`city_id`),
	ADD KEY `reviewed` (`reviewed`),
	ADD KEY `featured` (`featured`),
	ADD KEY `post_type_id` (`post_type_id`),
	ADD KEY `verified_email` (`verified_email`),
	ADD KEY `verified_phone` (`verified_phone`),
	ADD KEY `contact_name` (`contact_name`),
	ADD KEY `tags` (`tags`);

--
-- AUTO_INCREMENT for table `<<prefix>>posts`
--
ALTER TABLE `<<prefix>>posts`
	MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>post_types`
--

DROP TABLE IF EXISTS `<<prefix>>post_types`;
CREATE TABLE `<<prefix>>post_types`
(
	`id` int(10) UNSIGNED NOT NULL,
	`translation_lang` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
	`translation_of` int(10) UNSIGNED DEFAULT NULL,
	`name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
	`lft` int(10) UNSIGNED DEFAULT NULL,
	`rgt` int(10) UNSIGNED DEFAULT NULL,
	`depth` int(10) UNSIGNED DEFAULT NULL,
	`active` tinyint(1) DEFAULT '1'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>post_types`
--
ALTER TABLE `<<prefix>>post_types`
	ADD PRIMARY KEY (`id`),
	ADD KEY `translation_lang` (`translation_lang`),
	ADD KEY `translation_of` (`translation_of`);

--
-- AUTO_INCREMENT for table `<<prefix>>post_types`
--
ALTER TABLE `<<prefix>>post_types`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>post_values`
--

DROP TABLE IF EXISTS `<<prefix>>post_values`;
CREATE TABLE `<<prefix>>post_values`
(
	`id` bigint(20) UNSIGNED NOT NULL,
	`post_id` bigint(20) UNSIGNED DEFAULT NULL,
	`field_id` int(10) UNSIGNED DEFAULT NULL,
	`option_id` bigint(20) UNSIGNED DEFAULT NULL,
	`value` text COLLATE utf8_unicode_ci
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>post_values`
--
ALTER TABLE `<<prefix>>post_values`
	ADD PRIMARY KEY (`id`),
	ADD KEY `post_id` (`post_id`),
	ADD KEY `field_id` (`field_id`),
	ADD KEY `option_id` (`option_id`);

--
-- AUTO_INCREMENT for table `<<prefix>>post_values`
--
ALTER TABLE `<<prefix>>post_values`
	MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>report_types`
--

DROP TABLE IF EXISTS `<<prefix>>report_types`;
CREATE TABLE `<<prefix>>report_types`
(
	`id` int(10) UNSIGNED NOT NULL,
	`translation_lang` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
	`translation_of` int(10) UNSIGNED DEFAULT NULL,
	`name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT ''
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>report_types`
--
ALTER TABLE `<<prefix>>report_types`
	ADD PRIMARY KEY (`id`),
	ADD KEY `translation_lang` (`translation_lang`),
	ADD KEY `translation_of` (`translation_of`);

--
-- AUTO_INCREMENT for table `<<prefix>>report_types`
--
ALTER TABLE `<<prefix>>report_types`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>saved_posts`
--

DROP TABLE IF EXISTS `<<prefix>>saved_posts`;
CREATE TABLE `<<prefix>>saved_posts`
(
	`id` bigint(20) UNSIGNED NOT NULL,
	`user_id` bigint(20) UNSIGNED DEFAULT NULL,
	`post_id` bigint(20) UNSIGNED DEFAULT NULL,
	`created_at` timestamp NULL DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>saved_posts`
--
ALTER TABLE `<<prefix>>saved_posts`
	ADD PRIMARY KEY (`id`),
	ADD KEY `user_id` (`user_id`),
	ADD KEY `post_id` (`post_id`);

--
-- AUTO_INCREMENT for table `<<prefix>>saved_posts`
--
ALTER TABLE `<<prefix>>saved_posts`
	MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>saved_search`
--

DROP TABLE IF EXISTS `<<prefix>>saved_search`;
CREATE TABLE `<<prefix>>saved_search`
(
	`id` bigint(20) UNSIGNED NOT NULL,
	`country_code` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL,
	`user_id` bigint(20) UNSIGNED DEFAULT NULL,
	`keyword` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'To show',
	`query` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`count` int(10) UNSIGNED DEFAULT '0',
	`created_at` timestamp NULL DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>saved_search`
--
ALTER TABLE `<<prefix>>saved_search`
	ADD PRIMARY KEY (`id`),
	ADD KEY `user_id` (`user_id`),
	ADD KEY `country_code` (`country_code`);

--
-- AUTO_INCREMENT for table `<<prefix>>saved_search`
--
ALTER TABLE `<<prefix>>saved_search`
	MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>sessions`
--

DROP TABLE IF EXISTS `<<prefix>>sessions`;
CREATE TABLE `<<prefix>>sessions`
(
	`id` varchar(11) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
	`payload` text COLLATE utf8_unicode_ci,
	`last_activity` int(10) UNSIGNED DEFAULT NULL,
	`user_id` int(10) UNSIGNED DEFAULT NULL,
	`ip_address` varchar(250) COLLATE utf8_unicode_ci DEFAULT '',
	`user_agent` text COLLATE utf8_unicode_ci NOT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>sessions`
--
ALTER TABLE `<<prefix>>sessions`
	ADD PRIMARY KEY (`id`);



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>settings`
--

DROP TABLE IF EXISTS `<<prefix>>settings`;
CREATE TABLE `<<prefix>>settings`
(
	`id` int(10) UNSIGNED NOT NULL,
	`key` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
	`name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
	`value` text COLLATE utf8_unicode_ci,
	`description` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
	`field` text COLLATE utf8_unicode_ci,
	`parent_id` int(10) UNSIGNED DEFAULT NULL,
	`lft` int(10) UNSIGNED DEFAULT NULL,
	`rgt` int(10) UNSIGNED DEFAULT NULL,
	`depth` int(10) UNSIGNED DEFAULT NULL,
	`active` tinyint(1) NOT NULL,
	`created_at` timestamp NULL DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>settings`
--
ALTER TABLE `<<prefix>>settings`
	ADD PRIMARY KEY (`id`),
	ADD KEY `key` (`key`),
	ADD KEY `active` (`active`);

--
-- AUTO_INCREMENT for table `<<prefix>>settings`
--
ALTER TABLE `<<prefix>>settings`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>subadmin1`
--

DROP TABLE IF EXISTS `<<prefix>>subadmin1`;
CREATE TABLE `<<prefix>>subadmin1`
(
	`id` bigint(20) UNSIGNED NOT NULL,
	`code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
	`country_code` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL,
	`name` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
	`asciiname` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
	`active` tinyint(1) DEFAULT '1'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>subadmin1`
--
ALTER TABLE `<<prefix>>subadmin1`
	ADD PRIMARY KEY (`id`),
	ADD UNIQUE KEY `code` (`code`),
	ADD KEY `country_code` (`country_code`),
	ADD KEY `name` (`name`),
	ADD KEY `active` (`active`);

--
-- AUTO_INCREMENT for table `<<prefix>>subadmin1`
--
ALTER TABLE `<<prefix>>subadmin1`
	MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>subadmin2`
--

DROP TABLE IF EXISTS `<<prefix>>subadmin2`;
CREATE TABLE `<<prefix>>subadmin2`
(
	`id` bigint(20) UNSIGNED NOT NULL,
	`code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
	`country_code` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL,
	`subadmin1_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
	`name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
	`asciiname` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
	`active` tinyint(1) DEFAULT '1'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>subadmin2`
--
ALTER TABLE `<<prefix>>subadmin2`
	ADD PRIMARY KEY (`id`),
	ADD UNIQUE KEY `code` (`code`),
	ADD KEY `country_code` (`country_code`),
	ADD KEY `subadmin1_code` (`subadmin1_code`),
	ADD KEY `name` (`name`),
	ADD KEY `active` (`active`);

--
-- AUTO_INCREMENT for table `<<prefix>>subadmin2`
--
ALTER TABLE `<<prefix>>subadmin2`
	MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>time_zones`
--

DROP TABLE IF EXISTS `<<prefix>>time_zones`;
CREATE TABLE `<<prefix>>time_zones`
(
	`id` int(10) UNSIGNED NOT NULL,
	`country_code` varchar(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
	`time_zone_id` varchar(40) COLLATE utf8_unicode_ci DEFAULT '',
	`gmt` double DEFAULT NULL,
	`dst` double DEFAULT NULL,
	`raw` double DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>time_zones`
--
ALTER TABLE `<<prefix>>time_zones`
	ADD PRIMARY KEY (`id`),
	ADD UNIQUE KEY `time_zone_id` (`time_zone_id`),
	ADD KEY `country_code` (`country_code`);

--
-- AUTO_INCREMENT for table `<<prefix>>time_zones`
--
ALTER TABLE `<<prefix>>time_zones`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>users`
--

DROP TABLE IF EXISTS `<<prefix>>users`;
CREATE TABLE `<<prefix>>users`
(
	`id` bigint(20) UNSIGNED NOT NULL,
	`country_code` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL,
	`language_code` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
	`user_type_id` int(10) UNSIGNED DEFAULT NULL,
	`gender_id` int(10) UNSIGNED DEFAULT NULL,
	`name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`about` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`phone` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
	`phone_hidden` tinyint(1) UNSIGNED DEFAULT '0',
	`username` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`email_verified_at` timestamp NULL DEFAULT NULL,
	`password` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
	`remember_token` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`is_admin` tinyint(1) UNSIGNED DEFAULT '0',
	`can_be_impersonated` tinyint(1) UNSIGNED DEFAULT '1',
	`disable_comments` tinyint(1) UNSIGNED DEFAULT '0',
	`receive_newsletter` tinyint(1) UNSIGNED DEFAULT '1',
	`receive_advice` tinyint(1) UNSIGNED DEFAULT '1',
	`ip_addr` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
	`provider` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
	`provider_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
	`email_token` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
	`phone_token` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
	`verified_email` tinyint(1) UNSIGNED DEFAULT '1',
	`verified_phone` tinyint(1) UNSIGNED DEFAULT '0',
	`blocked` tinyint(1) UNSIGNED DEFAULT '0',
	`closed` tinyint(1) UNSIGNED DEFAULT '0',
	`last_login_at` datetime DEFAULT NULL,
	`created_at` timestamp NULL DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL,
	`deleted_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>users`
--
ALTER TABLE `<<prefix>>users`
	ADD PRIMARY KEY (`id`),
	ADD KEY `country_code` (`country_code`),
	ADD KEY `user_type_id` (`user_type_id`),
	ADD KEY `gender_id` (`gender_id`),
	ADD KEY `phone` (`phone`),
	ADD KEY `username` (`username`),
	ADD KEY `email` (`email`),
	ADD KEY `verified_email` (`verified_email`),
	ADD KEY `verified_phone` (`verified_phone`),
	ADD KEY `is_admin` (`is_admin`),
	ADD KEY `can_be_impersonated` (`can_be_impersonated`);

--
-- AUTO_INCREMENT for table `<<prefix>>users`
--
ALTER TABLE `<<prefix>>users`
	MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>user_types`
--

DROP TABLE IF EXISTS `<<prefix>>user_types`;
CREATE TABLE `<<prefix>>user_types`
(
	`id` tinyint(1) UNSIGNED NOT NULL,
	`name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
	`active` tinyint(1) UNSIGNED DEFAULT '1'
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>user_types`
--
ALTER TABLE `<<prefix>>user_types`
	ADD PRIMARY KEY (`id`),
	ADD KEY `active` (`active`);



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>permissions`
--

DROP TABLE IF EXISTS `<<prefix>>permissions`;
CREATE TABLE `<<prefix>>permissions`
(
	`id` int(10) UNSIGNED NOT NULL,
	`name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`guard_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL,
	`created_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>permissions`
--
ALTER TABLE `<<prefix>>permissions`
	ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for table `<<prefix>>permissions`
--
ALTER TABLE `<<prefix>>permissions`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>roles`
--

DROP TABLE IF EXISTS `<<prefix>>roles`;
CREATE TABLE `<<prefix>>roles`
(
	`id` int(10) UNSIGNED NOT NULL,
	`name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`guard_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
	`updated_at` timestamp NULL DEFAULT NULL,
	`created_at` timestamp NULL DEFAULT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>roles`
--
ALTER TABLE `<<prefix>>roles`
	ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for table `<<prefix>>roles`
--
ALTER TABLE `<<prefix>>roles`
	MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>model_has_permissions`
--

DROP TABLE IF EXISTS `<<prefix>>model_has_permissions`;
CREATE TABLE `<<prefix>>model_has_permissions`
(
	`permission_id` int(10) UNSIGNED NOT NULL,
	`model_id` bigint(20) UNSIGNED NOT NULL,
	`model_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT ''
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>model_has_permissions`
--
ALTER TABLE `<<prefix>>model_has_permissions`
	ADD PRIMARY KEY (`permission_id`, `model_id`, `model_type`);

--
-- Constraints for table `<<prefix>>model_has_permissions`
--
ALTER TABLE `<<prefix>>model_has_permissions`
	ADD CONSTRAINT `<<prefix>>model_has_permissions_ibfk_1` FOREIGN KEY (`permission_id`) REFERENCES `<<prefix>>permissions` (`id`) ON DELETE CASCADE;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>model_has_roles`
--

DROP TABLE IF EXISTS `<<prefix>>model_has_roles`;
CREATE TABLE `<<prefix>>model_has_roles`
(
	`role_id` int(10) UNSIGNED NOT NULL,
	`model_id` bigint(20) UNSIGNED NOT NULL,
	`model_type` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT ''
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>model_has_roles`
--
ALTER TABLE `<<prefix>>model_has_roles`
	ADD PRIMARY KEY (`role_id`, `model_id`, `model_type`);

--
-- Constraints for table `<<prefix>>model_has_roles`
--
ALTER TABLE `<<prefix>>model_has_roles`
	ADD CONSTRAINT `<<prefix>>model_has_roles_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `<<prefix>>roles` (`id`) ON DELETE CASCADE;



-- --------------------------------------------------------

--
-- Table structure for table `<<prefix>>role_has_permissions`
--

DROP TABLE IF EXISTS `<<prefix>>role_has_permissions`;
CREATE TABLE `<<prefix>>role_has_permissions`
(
	`permission_id` int(10) UNSIGNED NOT NULL,
	`role_id` int(10) UNSIGNED NOT NULL
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8
  COLLATE = utf8_unicode_ci;

--
-- Indexes for table `<<prefix>>role_has_permissions`
--
ALTER TABLE `<<prefix>>role_has_permissions`
	ADD PRIMARY KEY (`permission_id`, `role_id`),
	ADD KEY `role_id` (`role_id`);

--
-- Constraints for table `<<prefix>>role_has_permissions`
--
ALTER TABLE `<<prefix>>role_has_permissions`
	ADD CONSTRAINT `<<prefix>>role_has_permissions_ibfk_1` FOREIGN KEY (`permission_id`) REFERENCES `<<prefix>>permissions` (`id`) ON DELETE CASCADE,
	ADD CONSTRAINT `<<prefix>>role_has_permissions_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `<<prefix>>roles` (`id`) ON DELETE CASCADE;



SET FOREIGN_KEY_CHECKS = 1;

/*!40101 SET CHARACTER_SET_CLIENT = @OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS = @OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION = @OLD_COLLATION_CONNECTION */;
