<?php

return [
    /*
    |--------------------------------------------------------------------------
    | GeoIP Driver Type
    |--------------------------------------------------------------------------
    |
    | Supported: "ip-api", "telize", "maxmind"
    |
    */
    'driver' => env('GEOIP_DRIVER', 'maxmind'),
    
    /*
    |--------------------------------------------------------------------------
    | Return random ipaddresses (useful for dev envs)
    |--------------------------------------------------------------------------
    */
    'random' => env('GEOIP_RANDOM', false),
    
    /*
    |--------------------------------------------------------------------------
    | IP-API Driver
    |--------------------------------------------------------------------------
    */
    'ip-api' => [
        /*
        |--------------------------------------------------------------------------
        | IP-API Pro Service Key
        |--------------------------------------------------------------------------
        */
        'key' => env('GEOIP_IPAPI_KEY'),
        
        /*
        |--------------------------------------------------------------------------
        | IP-API Secure connection
        |--------------------------------------------------------------------------
        |
        | Use http or https
        | Only applicable with the Pro service
        |
        */
        'secure' => env('GEOIP_IPAPI_SECURE'),
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Telize Driver
    |--------------------------------------------------------------------------
    */
    'telize' => [
        /*
        |--------------------------------------------------------------------------
        | Telize Secure connection
        |--------------------------------------------------------------------------
        |
        | Use http or https
        |
        */
        'secure' => env('GEOIP_TELIZE_SECURE'),
    ],
    
    /*
    |--------------------------------------------------------------------------
    | Maxmind Driver
    |--------------------------------------------------------------------------
    */
    'maxmind' => [
        /*
        |--------------------------------------------------------------------------
        | Maxmind Database
        |--------------------------------------------------------------------------
        |
        | Example: storage_path().'/database/maxmind/GeoLite2-City.mmdb'
        | GeoLite2-Country.mmdb => DON'T WORK!
        |
        */
        'database' => env('GEOIP_MAXMIND_DATABASE', storage_path('database/maxmind/GeoLite2-City.mmdb')),
        
        /*
        |--------------------------------------------------------------------------
        | Maxmind Web Service Info
        |--------------------------------------------------------------------------
        */
        'user_id' => env('GEOIP_MAXMIND_USER_ID'),
        'license_key' => env('GEOIP_MAXMIND_LICENSE_KEY'),
    ],
];
