<?php
/**
 * LaraClassified - Classified Ads Web Application
 * Copyright (c) BedigitCom. All Rights Reserved
 *
 * Website: http://www.bedigit.com
 *
 * LICENSE
 * -------
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the inclusion
 * of the above copyright notice. If you Purchased from Codecanyon,
 * Please read the full License from here - http://codecanyon.net/licenses/standard
 */

namespace App\Http\Controllers;

use Illuminate\Support\Facades\View;
use Torann\LaravelMetaTags\Facades\MetaTag;

class CountriesController extends FrontController
{
	/**
	 * CountriesController constructor.
	 */
	public function __construct()
	{
		parent::__construct();
	}
	
	/**
	 * @return View
	 */
	public function index()
	{
		$data = [];
		
		// Meta Tags
		MetaTag::set('title', getMetaTag('title', 'countries'));
		MetaTag::set('description', strip_tags(getMetaTag('description', 'countries')));
		MetaTag::set('keywords', getMetaTag('keywords', 'countries'));
		
		return view('countries', $data);
	}
}
